/*
 *  DeclarationsInClasses.cpp
 */

#include <iostream>

using namespace std;  //introduces namespace std

class Example
{
public:
  Example();
  int getValue()
  {
    return value;
  }
  
  void incrementValue()
  {
    value++;
  }
  
  enum Values
  {
    arbitraryVal1 = 45,
    arbitraryVal2,
    arbitraryVal3
  };

private:  
  static int value;  // This does not define "value", 
                     // it only declares it.
};

Example::Example()
{
  value = arbitraryVal2;
}

// Must provide a definition of the static member of Example
int Example::value;


int main()
{	
	Example e1;
	Example e2;
	
	e2.incrementValue();
	
	cout << "e1.getValue() yields: " << e1.getValue() << endl;
	
	// To access the enumerated values outside of the class,
	// use the fully qualified name:
	cout << "arbitraryVal3 is : " << (int)Example::arbitraryVal3 << endl;
	return 0;
}


